/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <String.h>     // String class
#include <MSWin.h>      // WINAPI
#include <Dialog.h>     // Dialog class
#include "Buttons.h"    // Resources in Buttons.DLL

class CButtonDlg : public Dialog
{
public:
	CButtonDlg() : Dialog( IDD_BTNS_BUTTONS_DLG, "Buttons" )
	{
		
	}
	
	virtual int  Create(HWND hParent = NULL)
	{    
		InitMsgMap();
		
		 // Launch the modeless dialog
		int nRet = Dialog::Create(hParent); 
		
		return nRet;
	}
  
		
protected:
	
EVENTS_BEGIN
	ON_INIT( OnInitDialog )
	ON_BN_CLICKED( IDC_BTNS_CHECK_BOX1, OnClickCheckBox )
	ON_BN_CLICKED( IDC_BTNS_CHECK_BOX2, OnClickCheckBox )
	ON_BN_CLICKED( IDC_BTNS_CHECK_BOX3, OnClickCheckBox )
	ON_BN_CLICKED( IDC_BTNS_PUSH_BUTTON, OnClickPushButton )
EVENTS_END

	BOOL OnInitDialog()
	{
		// Get all Check Box controls
		m_btnCheck1 = GetItem( IDC_BTNS_CHECK_BOX1 );   
		m_btnCheck2 = GetItem( IDC_BTNS_CHECK_BOX2 );
		m_btnCheck3 = GetItem( IDC_BTNS_CHECK_BOX3 );
		
		// Check all Check Boxes
		m_btnCheck1.Check = 1;
		m_btnCheck2.Check = 1;
		m_btnCheck3.Check = 1;
	
		return TRUE;
	}
	
	// OnClick event handler (for all Check Boxes)
	BOOL OnClickCheckBox( Control ctrl )
	{
		string str;
		
		// Get Check Box control that was clicked
		Button btnCheckBox( ctrl );
	
		// Create output message with caption (Text) of clicked button	
		if(	btnCheckBox.Check )
			str.Format("%s was just checked.", btnCheckBox.Text ); // If just checked
		else
			str.Format("%s was just cleared.", btnCheckBox.Text ); // Else just cleared
		
		// Output message modal to Dialog
		Window winDlg = GetWindow();
		MessageBox
		(
			winDlg.GetSafeHwnd(),
			str,
			"Buttons Dialog Message",
			MB_OK | MB_ICONINFORMATION
		);
		
		return TRUE;
	}
	
	// OnClick event handler (for Toggle All Push Button)
	BOOL OnClickPushButton( Control ctrl )
	{	
		// Toggle all Check Boxes
		m_btnCheck1.Check = mod( m_btnCheck1.Check + 1, 2 );
		m_btnCheck2.Check = mod( m_btnCheck2.Check + 1, 2 );
		m_btnCheck3.Check = mod( m_btnCheck3.Check + 1, 2 );
	
		return TRUE;
	}	
	
private:	
	Button m_btnCheck1;   
	Button m_btnCheck2;   
	Button m_btnCheck3; 
};